<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package liem
 */

$url = wp_get_attachment_url( get_post_thumbnail_id(get_the_ID()), 'thumbnail' ); 
?>
<div class="col mb-5" id="post-<?php the_ID(); ?>">
    <div class="card h-100">
        <!-- Product image-->
        <img class="card-img-top" src="<?php echo $url; ?>" alt="<?php echo get_the_title(); ?>" />
        <!-- Product details-->
        <div class="card-body p-4">
            <div class="text-center">
                <!-- Product name-->
                <h5 class="fw-bolder"><?php echo get_the_title(); ?></h5>
                <!-- Product price-->
                $40.00 - $80.00
            </div>
        </div>
        <!-- Product actions-->
        <div class="card-footer p-4 pt-0 border-top-0 bg-transparent">
            <div class="text-center"><a class="btn btn-outline-dark mt-auto" href="<?php echo get_the_permalink(); ?>">Buy Now</a></div>
        </div>
    </div>
</div>
