<?php
/**
 * Visual Composer
 *
 * @package CiyaShop
 */

/*
 * Prevent Visual Composer Redirection after plugin activation
 */
remove_action( 'admin_init', 'vc_page_welcome_redirect', 9999 );

/*
 * Force Visual Composer to initialize as "built into the theme". This will hide certain tabs under the Settings->Visual Composer page
 * http://tgmpluginactivation.com/faq/updating-bundled-visual-composer/
 * https://wpbakery.atlassian.net/wiki/pages/viewpage.action?pageId=524297
 */
add_action( 'vc_before_init', 'ciyashop_vc_set_as_theme' );
/**
 * Ciyashop vc set as theme
 */
function ciyashop_vc_set_as_theme() {
	vc_set_as_theme();

	$vc_supported_cpts = array(
		'page',
		'post',
	);
	vc_set_default_editor_post_types( $vc_supported_cpts );
}

add_action( 'admin_init', 'ciyashop_hide_vc_activation_nag' );
/**
 * Ciyashop hide vc activation nag
 */
function ciyashop_hide_vc_activation_nag() {
	if ( is_admin() ) {
		setcookie( 'vchideactivationmsg', '1', strtotime( '+3 years' ), '/' );
		setcookie( 'vchideactivationmsg_vc11', ( defined( 'WPB_VC_VERSION' ) ? WPB_VC_VERSION : '1' ), strtotime( '+3 years' ), '/' );
	}
}

/************************************************************************************
 *
 * Revolution Slider
 *
 *********************************************************************************** */

add_filter( 'theme_page_templates', 'ciyashop_remove_revslider_template', 11 );
/**
 * Remove Revolution Slider custom template.
 *
 * @param string $post_templates .
 */
function ciyashop_remove_revslider_template( $post_templates ) {
	unset( $post_templates['../public/views/revslider-page-template.php'] );

	return $post_templates;
}

/************************************************************************************
 *
 * Breadcrumb NavXT
 *
 *********************************************************************************** ssss*/

if ( function_exists( 'bcn_display' ) ) {
	/**
	 * Remove the blog from the 404 and search breadcrumb trail
	 *
	 * @param string $trail .
	 */
	function ciyashop_wpst_override_breadcrumb_trail( $trail ) {
		if ( is_404() || is_search() ) {
			unset( $trail->trail[1] );
			array_keys( $trail->trail );
		}
	}
}
add_action( 'bcn_after_fill', 'ciyashop_wpst_override_breadcrumb_trail' );

/************************************************************************************
 *
 * Redux Framework
 *
 *********************************************************************************** */
add_filter( 'redux/ciyashop_options/aURL_filter', 'ciyashop_remove_redux_ads' );
/**
 * Remove Redux Framework ads in Backend
 *
 * @param string $redux_ads .
 */
function ciyashop_remove_redux_ads( $redux_ads ) {
	return false;
}


/**
 * Filter sortable field type content.
 *
 * @param string $render Rendered field markup.
 * @param array  $field  Field data.
 * @return string
 */
function cardealer_tweak_redux_field_sortable( $render, $field ) {
	if ( class_exists( 'Redux' ) && in_array( $field['id'], array( 'mobile_sticky_footer_elements' ), true ) ) {
		$value = Redux::get_option( 'ciyashop_options', $field['id'] );

		ob_start();

		if ( empty( $field['mode'] ) ) {
			$field['mode'] = 'text';
		}

		if ( 'checkbox' !== $field['mode'] && 'text' !== $field['mode'] && 'toggle' !== $field['mode'] ) {
			$field['mode'] = 'text';
		}

		if ( 'toggle' === $field['mode'] ) {
			$field['mode'] = 'checkbox';
		}

		$class   = ( isset( $field['class'] ) ) ? $field['class'] : '';
		$options = $field['options'];

		// This is to weed out missing options that might be in the default
		// Why?  Who knows.  Call it a dummy check.
		if ( ! empty( $value ) ) {
			foreach ( $value as $k => $v ) {
				if ( ! isset( $options[ $k ] ) ) {
					unset( $value[ $k ] );
				}
			}
		}

		$no_sort = false;
		if ( empty( $value ) && ! is_array( $value ) ) {
			if ( ! empty( $field['options'] ) ) {
				$value = $field['options'];
			} else {
				$value = array();
			}
		}
		foreach ( $options as $k => $v ) {
			if ( ! isset( $value[ $k ] ) ) {

				// A save has previously been done.
				if ( is_array( $value ) && array_key_exists( $k, $value ) ) {
					$value[ $k ] = $v;

					// Missing database entry, meaning no save has yet been done.
				} else {
					$no_sort           = true;
					$value[ $k ] = '';
				}
			}
		}

		// If missing database entries are found, it means no save has been done
		// and therefore no sort should be done.  Set the default array in the same
		// order as the options array.  Why?  The sort order is based on the
		// saved default array.  If entries are missing, the sort is messed up.
		// - kp.
		if ( true === $no_sort ) {
			$dummy_arr = array();

			foreach ( $options as $k => $v ) {
				$dummy_arr[ $k ] = $value[ $k ];
			}
			unset( $value );
			$value = $dummy_arr;
			unset( $dummy_arr );
		}

		$use_labels  = false;
		$label_class = ' checkbox';
		if ( 'checkbox' !== $field['mode'] ) {
			if ( ( isset( $field['label'] ) && true === $field['label'] ) ) {
				$use_labels  = true;
				$label_class = ' labeled';
			}
		}

		echo '<ul id="' . esc_attr( $field['id'] ) . '-list" class="redux-sortable ' . esc_attr( $class ) . ' ' . esc_attr( $label_class ) . '">';

		foreach ( $value as $k => $nicename ) {
			$invisible = '';

			if ( 'checkbox' === $field['mode'] ) {
				if ( empty( $value[ $k ] ) ) {
					$invisible = 'invisible';
				}
			}

			echo '<li class="' . esc_attr( $invisible ) . '">';

			$checked = '';
			$name    = 'name="' . $field['name'] . $field['name_suffix'] . '[' . esc_attr( $k ) . ']" ';

			if ( 'checkbox' === $field['mode'] ) {
				$value_display = $value[ $k ];

				if ( ! empty( $value[ $k ] ) ) {
					$checked = 'checked="checked" ';
				}

				$class .= ' checkbox_sortable';
				$name   = '';
				echo '<input
						type="hidden"
						name="' . esc_attr( $field['name'] . $field['name_suffix'] ) . '[' . esc_attr( $k ) . ']"
						id="' . esc_attr( $field['id'] . '-' . $k ) . '-hidden"
						value="' . esc_attr( $value_display ) . '" />';

				echo '<div class="checkbox-container">';
			} else {
				$value_display = $value[ $k ] ? $value[ $k ] : '';
				$nicename      = $field['options'][ $k ];
			}

			if ( 'checkbox' !== $field['mode'] ) {
				if ( $use_labels ) {
					echo '<label class="bugger" for="' . esc_attr( $field['id'] ) . '[' . esc_attr( $k ) . ']"><strong>' . wp_kses( wp_specialchars_decode( $options[ $k ] ), array( 'span' => array() ) ) . '</strong></label>';
					echo '<br />';
				}

				echo '<input
					rel="' . esc_attr( $field['id'] . '-' . $k ) . '-hidden"
					class="' . esc_attr( $class ) . '" ' . esc_html( $checked ) . '
					type="' . esc_attr( $field['mode'] ) . '"
					' . $name . // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
					'id="' . esc_attr( $field['id'] . '[' . $k ) . ']"
					value="' . esc_attr( $value_display ) . '"
					placeholder="' . esc_attr( $nicename ) . '" />';
			}

			echo '<span class="compact drag">';
			echo '<i class="dashicons dashicons-menu icon-large"></i>';
			echo '</span>';

			if ( 'checkbox' === $field['mode'] ) {
				echo '<i class="dashicons dashicons-visibility visibility"></i>';

				if ( 'checkbox' === $field['mode'] ) {
					echo '<label for="' . esc_attr( $field['id'] . '[' . $k ) . ']"><strong>' . wp_kses( wp_specialchars_decode( $options[ $k ] ), array(
						'span' => array(),
						'i'    => array(
							'class' => true
						),
						'img'    => array(
							'src' => true
						),
					) ) . '</strong></label>';
				}
			}

			if ( 'checkbox' === $field['mode'] ) {
				echo '</div>';
			}

			echo '</li>';
		}

		echo '</ul>';
		$render = ob_get_contents();
		ob_end_clean();
	}
	return $render;
}
add_filter( 'redux/field/ciyashop_options/sortable/render/after', 'cardealer_tweak_redux_field_sortable', 10, 2 );
