<?php 

function add_phonepay_gateway($methods) {
    $methods[] = 'WC_Phonepay_Gateway';
    return $methods;
}
add_filter('woocommerce_payment_gateways', 'add_phonepay_gateway');


function phonepay_gateway_init() {
    if (!class_exists('WC_Payment_Gateway')) return;

class WC_Phonepay_Gateway extends WC_Payment_Gateway {

    function __construct() {

    $this->id = 'phonepay'; 
    $this->icon = $this->get_random_image(); 
    $this->method_description = 'Description of Phonepay payment gateway'; 
    $this->supports = array(
      'products'
    );
    $this->init_form_fields();
    $this->init_settings();
    //$this->title = $this->get_option( 'title' );

  }

  public function get_random_image() {
      $images = array(
          'https://worshipfaith.in/liem/wp-content/uploads/2024/10/Untitled-design-33.png',
      );

      return $images[array_rand($images)];
  }

  public function init_form_fields() {

      $this->form_fields = array(
        'enabled' => array(
          'title'       => esc_attr__( 'Enable/Disable', 'phonepay_pg' ),
          'label'       => esc_attr__( 'Enable Phonepay', 'phonepay_pg' ),
          'type'        => 'checkbox',
          'description' => '',
          'default'     => 'no'
        ),
        'title' => array(
          'title'       => esc_attr__( 'Title', 'phonepay_pg' ),
          'type'        => 'text',
          'description' => esc_attr__( 'This controls the title which the user sees during checkout.', 'phonepay_pg' ),
          'default'     => __( 'Phonepay', 'phonepay_pg' ),
          'desc_tip'    => true
        ),
        'description' => array(
          'title'       => esc_attr__( 'Description', 'phonepay_pg' ),
          'type'        => 'text',
          'description' => esc_attr__( 'This controls the description which the user sees during checkout.', 'phonepay_pg' ),
          'default'     => 'Pay with Phonepay.',
          'desc_tip'    => true
        )
      );
    
    }

    public function process_payment( $order_id ) {
      $order = wc_get_order( $order_id );

      $order->update_status( 'processing', __( 'Awaiting Phonepay payment.', 'phonepay_pg' ) );

      wc_reduce_stock_levels( $order_id );

      WC()->cart->empty_cart();

      return array(
          'result'   => 'success',
          'redirect' => $this->get_return_url( $order )
      );
    }

    }
}
add_action('plugins_loaded', 'phonepay_gateway_init');

