<?php 

function add_googlepay_gateway($methods) {
    $methods[] = 'WC_Googlepay_Gateway';
    return $methods;
}
add_filter('woocommerce_payment_gateways', 'add_googlepay_gateway');


function googlepay_gateway_init() {
    if (!class_exists('WC_Payment_Gateway')) return;

class WC_Googlepay_Gateway extends WC_Payment_Gateway {

    function __construct() {

	    $this->id = 'googlepay'; 
		$this->icon = $this->get_random_image(); 
		$this->method_description = 'Description of Googlepay payment gateway'; 
		$this->supports = array(
			'products'
		);
		$this->init_form_fields();
		$this->init_settings();
		//$this->title = $this->get_option( 'title' );
	}

	public function get_random_image() {
	    $images = array(
	        'https://worshipfaith.in/liem/wp-content/uploads/2024/10/Untitled-design-37.png',
	    );
    	return $images[array_rand($images)];
	}

	public function init_form_fields() {

	    $this->form_fields = array(
	      'enabled' => array(
	        'title'       => esc_attr__( 'Enable/Disable', 'googlepay_pg' ),
	        'label'       => esc_attr__( 'Enable Googlepay', 'googlepay_pg' ),
	        'type'        => 'checkbox',
	        'description' => '',
	        'default'     => 'no'
	      ),
	      'title' => array(
	        'title'       => esc_attr__( 'Title', 'googlepay_pg' ),
	        'type'        => 'text',
	        'description' => esc_attr__( 'This controls the title which the user sees during checkout.', 'googlepay_pg' ),
	        'default'     => __( 'Googlepay', 'googlepay_pg' ),
	        'desc_tip'    => true
	      ),
	      'description' => array(
	        'title'       => esc_attr__( 'Description', 'googlepay_pg' ),
	        'type'        => 'text',
	        'description' => esc_attr__( 'This controls the description which the user sees during checkout.', 'googlepay_pg' ),
	        'default'     => 'Pay with Googlepay.',
	        'desc_tip'    => true
	      )
	    );
	  
	  }
    public function process_payment( $order_id ) {
	    $order = wc_get_order( $order_id );

	    $order->update_status( 'processing', __( 'Awaiting Googlepay payment.', 'googlepay_pg' ) );

	    wc_reduce_stock_levels( $order_id );

	    WC()->cart->empty_cart();

	    return array(
	        'result'   => 'success',
	        'redirect' => $this->get_return_url( $order )
	    );
    }

    }
}
add_action('plugins_loaded', 'googlepay_gateway_init');

