<?php
$mobile_sticky_footer_elements = array();
if ( is_callable( 'ciyashop_mobile_sticky_footer_elements_options' ) ) {
	$mobile_sticky_footer_elements = ciyashop_mobile_sticky_footer_elements_options();
}

return array(
	'id'               => 'woocommerce_mobile_sticky_footer_settings',
	'title'            => esc_html__( 'Mobile Sticky Footer', 'pgs-core' ),
	'customizer_width' => '400px',
	'subsection'       => true,
	'fields'           => array(
		array(
			'id'       => 'woocommerce_mobile_sticky_footer',
			'type'     => 'switch',
			'title'    => esc_html__( 'Mobile Sticky Footer', 'pgs-core' ),
			'subtitle' => esc_html__( 'Show or hide sticky footer on the mobile devices.', 'pgs-core' ),
			'on'       => esc_html__( 'Show', 'pgs-core' ),
			'off'      => esc_html__( 'Hide', 'pgs-core' ),
			'default'  => true,
		),
		array(
			'id'       => 'mobile_sticky_footer_elements',
			'type'     => 'sortable',
			'mode'     => 'toggle', // toggle or text.
			'title'    => esc_html__( 'Show/hide Elements', 'pgs-core' ),
			'subtitle' => esc_html__( 'Show/hide element and reorder by drag-and-drop.', 'pgs-core' ),
			'desc'     => ''
			. '<strong>' . esc_html__( 'Important Note:', 'pgs-core' ) . '</strong>'
			. '<ol style="margin-left: 15px;margin-top: 5px;">'
				. '<li style="margin: 0;line-height: 20px !important;">' . esc_html__( 'Maximum 4 elements will be displayed.', 'pgs-core' ) . '</li>'
				. '<li style="margin: 0;line-height: 20px !important;">' . esc_html__( 'If no option is selected, default elements (Home, Wishlist, My Account, and Cart) will be displayed.', 'pgs-core' ) . '</li>'
			. '</ol>'
			. sprintf(
				/* translators: %s: WhatsApp Link */
				esc_html__( 'To add new elements, please refer to this document.: %s', 'pgs-core' ),
				'<a href="https://docs.potenzaglobalsolutions.com/docs/ciyashop-wp/?section=mobile-sticky-footer" rel="noopener" target="_blank">' . esc_html__( 'Mobile Sticky Footer', 'pgs-core' ) . '</a>'
			),
			'options'  => $mobile_sticky_footer_elements,
			'default'  => array(
				'home'      => 1,
				'wishlist'  => 1,
				'myaccount' => 1,
				'cart'      => 1,
			),
			'required' => array(
				array( 'woocommerce_mobile_sticky_footer', '=', 1 )
			),
		),
	),
);
