<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package liem
 */

get_header();
?>

	<?php
		while ( have_posts() ) :
			the_post();
			$url = wp_get_attachment_url( get_post_thumbnail_id(get_the_ID()), 'full' ); 
		?>
		<section class="py-5">
			<div class="container px-4 px-lg-5 my-5">
		        <div class="row gx-4 gx-lg-5 align-items-center">
		        	<h1 class="display-5 fw-bolder">
		        			<?php
								/* translators: %s: search query. */
								printf( esc_html__( 'Search Results for: %s', 'liem' ), '<span>' . get_search_query() . '</span>' );
							?>
					</h1>
		            <div class="col-md-12 lead"><?php echo get_the_content(); ?></div>
		        </div>
		    </div>
		</section>    
		<?php	
		endwhile; // End of the loop.
		wp_reset_postdata();

get_footer();