<?php // phpcs:ignore WordPress.Files.FileName.NotHyphenatedLowercase
/**
 * Sticky Footer Home file.
 *
 * @package CiyaShop
 */

$element         = $args['element'];
$element_data    = $args['element_data'];
$element_classes = $element_data['element_classes'];

if ( is_front_page() ) {
	$element_classes[] = 'sticky-footer-active';
}
$element_classes = implode( ' ', array_filter( array_unique( $element_classes ) ) );
?>
<div class="<?php echo esc_attr( $element_classes ); ?>">
	<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"  title="<?php echo esc_attr( $element_data['title'] ); ?>">
		<?php echo wp_kses( $element_data['icon'], ciyashop_allowed_html( array( 'img', 'i' ) ) ); ?>
	</a>
</div>
