<?php
/**
 * Theme functions and definitions.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 * @package CiyaShop
 */

/**
 * If your child theme has more than one .css file (eg. ie.css, style.css, main.css) then
 * you will have to make sure to maintain all of the parent theme dependencies.
 *
 * Make sure you're using the correct handle for loading the parent theme's styles.
 * Failure to use the proper tag will result in a CSS file needlessly being loaded twice.
 * This will usually not affect the site appearance, but it's inefficient and extends your page's loading time.
 *
 * @link https://codex.wordpress.org/Child_Themes
 */
function ciyashop_child_enqueue_styles() { // phpcs:ignore WordPress.WhiteSpace.ControlStructureSpacing.NoSpaceAfterOpenParenthesis

	wp_enqueue_style( 'ciyashop-style', get_parent_theme_file_uri( '/css/style.css' ), array(), '3.5.2' );

	if ( is_rtl() ) {
		wp_enqueue_style( 'rtl-style', get_parent_theme_file_uri( '/rtl.css' ), array(), '3.5.2' );
	}

	wp_enqueue_style(
		'ciyashop-child-child-style',
		get_stylesheet_directory_uri() . '/style.css',
		array( 'ciyashop-style' ),
		wp_get_theme()->get( 'Version' )
	);
}
add_action( 'wp_enqueue_scripts', 'ciyashop_child_enqueue_styles', 11 );

/* add to cart change text*/
add_filter( 'woocommerce_product_single_add_to_cart_text', 'bbloomer_custom_add_cart_button', 9999 ); 
add_filter( 'woocommerce_product_add_to_cart_text', 'bbloomer_custom_add_cart_button', 9999 );
  
function bbloomer_custom_add_cart_button() {
   return 'Buy it now';
}

/* add to cart to checkout page */

add_filter ('woocommerce_add_to_cart_redirect', function( $url, $adding_to_cart ) {
    return wc_get_checkout_url();
}, 10, 2 );


add_filter('woocommerce_dropdown_variation_attribute_options_args','woo_select_default_option',10,1);

function woo_select_default_option( $args){

    if(count($args['options']) > 0) //Ensure product variation isn't empty
        $args['selected'] = $args['options'][0];
    return $args;
}