<?php
/**
 * Plugin Name: 		UPI Payment Gateways
 * Description: 		Here is a UPI Payment Gateway Available For Phonepay,Googlepay,Paytm Payment Gateway.
 * Version:           	1.0.0
 * Requires at least: 	5.2
 * Requires PHP:      	7.2
 * Author:            	Geekerhub
 * Author URI:        	https://profiles.wordpress.org/iqbal1486/
 * License:           	GPL v2 or later
 * License URI:       	https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       	wpgpp-gateway
 */


if ( ! defined( 'ABSPATH' ) ) {
    exit( 'restricted access' );
}

define( 'GPP_VERSION', '1.0.0' );

if (! defined('GPP_ADMIN_URL') ) {
    define('GPP_ADMIN_URL', get_admin_url());
}

if (! defined('GPP_PLUGIN_FILE') ) {
    define('GPP_PLUGIN_FILE', __FILE__);
}

if (! defined('GPP_PLUGIN_PATH') ) {
    define('GPP_PLUGIN_PATH', plugin_dir_path(GPP_PLUGIN_FILE));
}

if (! defined('GPP_PLUGIN_URL') ) {
    define('GPP_PLUGIN_URL', plugin_dir_url(GPP_PLUGIN_FILE));
}

include_once GPP_PLUGIN_PATH."/admin/paytm.php";
include_once GPP_PLUGIN_PATH."/admin/googlepay.php";
include_once GPP_PLUGIN_PATH."/admin/phonepay.php";

function gpp_enqueue_script() {
    wp_enqueue_script('customjs', plugins_url('/asset/gateway.js', __FILE__), array(), '1.0.0', true);
    wp_enqueue_style('example-small-css', plugins_url('/asset/admin.css', __FILE__), array(), '1.0.0');
    
    if (is_checkout()) {
        
        wp_localize_script( 'customjs', 'wc_cart_params', array(
            'cart_total' => WC()->cart->total,
        ));
    }
}
add_action('wp_enqueue_scripts', 'gpp_enqueue_script');


